-- DailyGSTSummary(date integer, salesSR integer, salesZR integer, salesGST integer, purchaseSR integer, purchaseZR integer, purchaseGST integer)
@column-sizes(2|1|1|1|1|1|1|1|1)
select 
   c.name as DAY,
   sum(salesSR) as "SR-SALES@dividefactor@sum=sum",
   sum(salesZR) as "ZR-SALES@dividefactor@sum=sum",
   sum(salesSR+salesZR) as "SALES@dividefactor@sum=sum",
   sum(salesGST) as "OUTPUT TAX@dividefactor@sum=sum",
   sum(purchaseSR) as "SR-PURCHASES@dividefactor@sum=sum",
   sum(purchaseZR) as "ZR-PURCHASES@dividefactor@sum=sum",
   sum(purchaseSR+purchaseZR) as "PURCHASES@dividefactor@sum=sum",
   sum(purchaseGST) as "INPUT TAX@dividefactor@sum=sum"
from DailyGSTSummary s
inner join calendar c on s.date between c.fromDate and c.toDate
where type='DAY' and c.fromDate >= @fromdate and c.toDate <= @todate
group by c.name
order by c.id;
