-- export all sales, purchase and adjustments.
select  
	sh.id as "SalesID@number",
	sh.transactionDate as "DATE@date",
	(select gettoken(content,1) from entity e inner join entityfts ef on e.docid=ef.rowid where e.id=sh.customerid) as CUSTOMER,
	(select gettoken(content,0) || ' ' || gettoken(content,1) from entity e inner join entityfts ef on e.docid=ef.rowid where e.id=sd.stockid) as ITEM,
	sd.quantity as "QUANTITY@number",
	sd.amount as "AMOUNT@dividefactor"
from salesheader sh
inner join salesdetail sd on sd.salesid=sh.id
inner join stock s on s.entityID=sd.stockID
where sh.isDeleted is NULL and s.isDeleted is NULL and sh.transactionDate between @fromdate and @todate
order by sh.transactionDate;


select  
	sh.id as "PurchaseID@number",
    sh.refno as "REFERENCE", 
	sh.transactionDate as "DATE@date",
	(select gettoken(content,1) from entity e inner join entityfts ef on e.docid=ef.rowid where e.id=sh.supplierID) as SUPPLIER,
	(select gettoken(content,0) || ' ' || gettoken(content,1) from entity e inner join entityfts ef on e.docid=ef.rowid where e.id=sd.stockid) as ITEM,
	sd.quantity as "QUANTITY@number",
	sd.amount as "AMOUNT@dividefactor"
from receivedetail sd 
inner join stock s on s.entityID=sd.stockID
inner join receiveheader sh on sh.id=sd.receiveID where sh.isDeleted is NULL and s.isDeleted is NULL and transactionDate between @fromdate and @todate
order by sh.transactionDate;


select * from stocktransdetail rd
inner join stocktransheader rh on rh.id=rd.stocktransID where transactionDate between @fromdate and @todate;