select 
    e.id as "ID", 
    (select gettoken(content,1) from entityfts ef where ef.rowid=e.docid) as "NAME",
    (select packsize from stockpackmaster where stockid=e.id order by packsize desc limit 1) as "PACKSIZE",
	(select packdescription from stockpackmaster where stockid=e.id order by packsize desc limit 1) as "PACKING",
	0 as "QTY",
	sq.qoh as "QTYLOOSE",
	(select gettoken(content,2) from entityfts ef where ef.rowid=e.docid) as "MAL",
	(select batchNo from receivedetail where stockid=e.id order by receiveID desc limit 1) as "BATCHNO", 
	(select strftime("%m/%Y", expiryDate/1000, 'unixepoch', 'localtime') from receivedetail where stockid=e.id order by receiveID desc limit 1) as "EXPIRYDATE",
	0 as "COST@dividefactor",
	sq.latestCost as "COSTLOOSE@dividefactor",
	(select sellingprice from stockpack where stockid=e.id order by packsize desc limit 1) as "PRICE@dividefactor",
	(select sellingprice from stockpack where stockid=e.id order by packsize limit 1) as "PRICELOOSE@dividefactor",
    (select gettoken(content,0) from entityfts ef where ef.rowid=e.docid) as "CODE"
from stock s
inner join entity e on e.id=s.entityid
inner join stockqoh sq on sq.stockid=e.id
where s.isDeleted is NULL and e.isDeleted is NULL and sq.qoh > 0