@column-sizes(1|5|1|1|1|2|2|2|1|2)
@footer(|*||||sum|sum|sum||sum)
@row-function(||||||||c[2]+c[3]-c[4]|c[5]+c[6]-c[7])

select
   gettoken(ef.content, 0) as CODE,
   gettoken(ef.content, 1) as NAME,
   (select sum(q) from StockOpen where stockID=s.entityID) as "Q-Open@integer",
   (select sum(q) from StockIn where stockID=s.entityID) as "Q-In@integer",
   (select sum(q) from StockOut where stockID=s.entityID) as "Q-Out@integer",
   (select sum(v) from StockOpen where stockID=s.entityID) as "Cost-Open@dividefactor@sum=sum",
   (select sum(v) from StockIn where stockID=s.entityID) as "Cost In@dividefactor@sum=sum",
   (select sum(v) from StockOut where stockID=s.entityID) as "Cost Out@dividefactor@sum=sum",
@ifExcel
   0 as "Q-Closing@integer@formula=C@row+D@row-E@row",
   0 as "Cost-Closing@decimal@formula=F@row+G@row-H@row"
@end
@ifPDF
   0 as "Q-Closing@integer",
   0 as "Cost-Closing@decimal"
@end
from stock s
inner join entity e on e.id=s.entityID
inner join entityfts ef on ef.rowid=e.docid
where s.isDeleted is NULL and e.IsDeleted is NULL
   and (gettoken(ef.content, 0) > '' or gettoken(ef.content, 1) > '')
order by 2;
