-- const addressIndexCode = 0;
-- const addressIndexName = 1;
-- const addressIndexIC = 2;
-- const addressIndexRegNo = 2;
-- const addressIndexEmail = 3;
-- const addressIndexTelNo = 4;
-- const addressIndexFaxNo = 5;
-- const addressIndexContact = 6;
-- const addressIndexAddress = 7;

-- distinct customerID  => s.customerID
-- no of customer = number of receipts => s.id

create temp table summaryByDay as 
select 
  date(s.date/1000, 'unixepoch', 'localtime') as day,
  s.date as numericDay,
  count(distinct(s.id)) as ncust,
  sum(effectiveAmount) as totsales
from DailySalesSummaryByCategory s 
group by 1

;

@column-sizes(4|1|1)

select 
  strftime('%Y-%m', day) as Day,
  sum(ncust) as [No of Customers@number],
  sum(totsales) as [Total Sales@dividefactor]
from summaryByDay
group by 1

union all 

select 
  strftime('%Y-%m-%d', day) as Day,
  sum(ncust) as [No of Customers@number],
  sum(totsales) as [Total Sales@dividefactor]
from summaryByDay
group by 1


;

@column-sizes(4|2|1|1)

select 
    (select gettoken(content,1) from entityFTS where rowid=e.docid) as [Name], 
    (select gettoken(content,4) from entityFTS where rowid=e.docid) as [Tel], 
    count(distinct(s.id)) as [No of Visit@number],
    sum(s.effectiveAmount) as [Amount@dividefactor]
from DailySalesSummaryByCategory s
inner join membership m on m.entityid = s.customerId
inner join entity e on e.id=m.entityId
group by customerID
order by 3 desc

;