-- enum Fields {code, name, ic, email, telNo, faxNo, contact, address, postcode, state, country, gpsCoord, allergy, medicalHistory, longTermMedication, remark, eof};

@column-sizes(1|3|7|3|2|2|7|2|2|2|2|2|2|2)
@footer(||||||*|||||sum||sum)

select 
    '' as BIL,
	gettoken(ef.content,4) as TEL,
	gettoken(ef.content,1) as NAME,
	gettoken(ef.content,2) as IC,
    p.dob as 'DATE OF BIRTH@date',
	gettoken(ef.content,3) as 'e-mail',
	gettoken(ef.content,7) as ADDRESS,
	gettoken(ef.content,12) as ALLERGY,
	gettoken(ef.content,13) as 'MEDICAL HISTORY',
	gettoken(ef.content,14) as 'LONG TERM MEDICATION',
	gettoken(ef.content,15) as REMARK,
    (select balance/10000 from membershippoints where entityid=m.entityid order by paymentID desc limit 1) as 'POINTS@integer',
    (select transactiondate from salesheader where customerid=m.entityid and isdeleted is NULL order by transactionDate desc limit 1) as 'LATEST VISIT@date',
    (select totalAmount from salesheader where customerid=m.entityid and isdeleted is NULL order by transactionDate desc limit 1) as 'LATEST PURCHASE@dividefactor'
from membership m
inner join person p on p.entityID=m.entityID
inner join entity e on e.id=p.entityid
inner join entityfts ef on ef.rowid=e.docid
where p.isDeleted is NULL and e.isDeleted is NULL and m.isDeleted is NULL 
and exists(select * from salesheader where customerID = e.id)
and gettoken(ef.content,1) > '' and gettoken(ef.content,0) != 'TMP' 
order by 3,4
