-- enum Fields {code, name, ic, email, telNo, faxNo, contact, address, postcode, state, country, gpsCoord, allergy, medicalHistory, longTermMedication, remark, eof};

@column-sizes(7|3|3|3|8|2|3|2)
@footer(||||*|sum||sum)

select 
	gettoken(ef.content,1) as NAME,
	gettoken(ef.content,4) as TEL,
    p.dob as 'DATE OF BIRTH@date',
	gettoken(ef.content,3) as 'e-mail',
	multilines(gettoken(ef.content,2), gettoken(ef.content,7)) as 'IC/ADDRESS',
    (select balance/10000 from membershippoints where entityid=m.entityid order by paymentID desc limit 1) as 'POINTS@integer',
    (select transactiondate from salesheader where customerid=m.entityid and isdeleted is NULL order by transactionDate desc limit 1) as 'LATEST VISIT@date',
    (select totalAmount from salesheader where customerid=m.entityid and isdeleted is NULL order by transactionDate desc limit 1) as 'LATEST PURCHASE@dividefactor'
--    strftime('%j', date(p.dob/1000, 'unixepoch','localtime')) as dayOfYear,
--    strftime('%j', date(@fromdate/1000, 'unixepoch','localtime')) as fromString,
--    strftime('%j', date(@todate/1000, 'unixepoch','localtime')) as toString
from membership m
inner join person p on p.entityID=m.entityID
inner join entity e on e.id=p.entityid
inner join entityfts ef on ef.rowid=e.docid
where p.isDeleted is NULL and e.isDeleted is NULL and m.isDeleted is NULL 
and gettoken(ef.content,1) > '' and gettoken(ef.content,0) != 'TMP' 
and exists(select * from salesheader where customerID = e.id)
and strftime('%j', date(p.dob/1000, 'unixepoch','localtime')) between strftime('%j', date(@fromdate/1000, 'unixepoch','localtime')) and strftime('%j', date(@todate/1000, 'unixepoch','localtime'))
order by strftime('%j', date(p.dob/1000, 'unixepoch','localtime'))
