 
 drop table if exists dupItems;
 create temp table dupItems as 
    select gettoken(ef.content,0) as Code, count(*) as cnt
    from entity e
    inner join entityfts ef on ef.rowid=e.docid
    inner join stock s on s.entityid=e.id
    where s.isdeleted is null and e.isdeleted is null
    group by gettoken(ef.content,0);

create index idx_dupItems_code on dupItems(code);
delete from dupItems where cnt <= 1;

@column-sizes(1|2|6|1|1)
select 
 	e.id, 
	gettoken(ef.content,0) as [Code], 
	gettoken(ef.content,1) as Name, 
	(select packsize from stockpackmaster pk inner join types t on pk.packtypeid=t.id where pk.stockid=e.id and t.code='' limit 1) as [PkSize],
	formatqoh(e.id, ifnull(sq.qoh,0)) as QOH
from stock s 
inner join stockQOH sq on sq.stockID=s.entityID 
inner join entity e on e.id=s.entityid 
inner join entityfts ef on ef.rowid=e.docid 
where s.isDeleted is NULL and e.isDeleted is NULL and exists(select * from dupItems where code=gettoken(ef.content,0))
order by 2;
