 
 select 
 	e.id, 
	gettoken(ef.content,0) as Code, 
	gettoken(ef.content,1) as Name, 
	(select group_concat(gettoken(ef.content,0)) from entityfts ef inner join entity es on es.docid=ef.rowid inner join EntityRelationship er on er.PairID=es.id where er.EntityID=e.id and er.typeID = (select value from ul_keys where key='entityRelationShelf')) as [Shelf],
	(select packsize from stockpackmaster pk inner join types t on pk.packtypeid=t.id where pk.stockid=e.id and t.code='' limit 1) as [PkSize],
	ifnull(sq.qoh,0) as [L-QOH],
	formatqoh(e.id, ifnull(sq.qoh,0)) as QOH,
	(sq.weightedAvgCost*(select packsize from stockpackmaster pk inner join types t on pk.packtypeid=t.id where pk.stockid=e.id and t.code='' limit 1)) as [Cost],
	(sq.weightedAvgCost*(select packsize from stockpackmaster pk inner join types t on pk.packtypeid=t.id where pk.stockid=e.id and t.code='L' limit 1)) as [L-Cost],
	(select sellingPrice from stockpack pk inner join types t on pk.packtypeid=t.id where pk.stockid=e.id and t.code='' limit 1) as [Price],
	(select sellingPrice from stockpack pk inner join types t on pk.packtypeid=t.id where pk.stockid=e.id and t.code='L' limit 1) as [L-Price],
	ifnull(sq.qoh,0)*(sq.weightedAvgCost) as [Value],
	sq.latestReceiveDate as [Received],
	(select checkDate from StockQOHCheck where stockID=s.entityID order by checkDate desc limit 1) as [Last Check],
	(select u.code from StockQOHCheck sc inner join ul_sessions ses on ses.id=sc.sessionID inner join ul_users u on u.id=ses.userid where sc.stockID=s.entityID order by sc.checkDate desc limit 1) as [Who] 
from stock s 
inner join stockQOH sq on sq.stockID=s.entityID 
inner join entity e on e.id=s.entityid 
inner join entityfts ef on ef.rowid=e.docid 
where s.isDeleted is NULL and e.isDeleted is NULL
