
create temp table if not exists ActiveItems(
	id integer, 
	code text, 
	name text, 
	shelf text, 
	qoh text, 
	stockvalue real, 
	latestReceiveDate integer, 
	latestSalesDate integer, 
	latestActiveDate integer,
	activeMonth integer
); 

delete from ActiveItems;

insert into ActiveItems (id, code, name, shelf, qoh, stockValue, latestReceiveDate, latestSalesDate, latestActiveDate, activeMonth)
	select 
		e.id as id, 
		gettoken(ef.content,0) as code, 
		gettoken(ef.content,1) as name, 
		(select group_concat(gettoken(ef.content,0)) from entityfts ef inner join entity e on e.docid=ef.rowid inner join EntityRelationship er on er.PairID=e.id where er.EntityID=e.id and er.typeID = (select value from ul_keys where key='entityRelationShelf')) as [shelf],
		formatqoh(e.id, getQOH(sq)) as qoh, 
		sq.qoh*sq.weightedAvgCost as "stockvalue", 
		ifnull(latestReceiveDate,0), ifnull(latestSalesDate,0), ifnull(latestActiveDate,0),
		agemonth(latestActiveDate) as activeMonth
	from stock s
    inner join stockQOH sq on sq.stockID=s.entityID
	inner join entity e on e.id=s.entityid 
	inner join entityfts ef on ef.rowid=e.docid  
	where s.isDeleted is NULL;

@ifPDF
	@column-sizes(1|2|6|2|1|2|2|2|2|1)
	@footer(||*|||sum|||)
@end

select 
	id, 
	code as Code, 
	name as Name, 
	shelf as "Shelf",
	qoh as QOH, 
	stockvalue as "Stock Value@dividefactor@sum=sum", 
	latestReceiveDate as "Latest Received@date", 
	latestSalesDate as "Latest Sales@date", 
	latestActiveDate as "Latest Active@date", 
	activeMonth as "Active Months@number"
from activeItems
where activeMonth <= @nmonth and activeMonth >= 0
order by name;
