
drop table if exists private.entityname;

create table private.entityname as 
select 
  e.id,
  gettoken(ef.content,0) as code, 
  gettoken(ef.content,1) as name,
  gettoken(ef.content,7) as generic,
  (select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as packsize,
  (select packDescription from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as packing,
  (select sellingPrice from stockpack where stockid=s.entityid order by sellingPrice desc limit 1) as sellingprice_pack,
  (select sellingPrice from stockpack where stockid=s.entityid order by sellingPrice limit 1) as sellingprice_loose
from entityfts ef 
inner join entity e on e.docid=ef.rowid 
inner join stock s on s.entityid=e.id
where s.isDeleted is null and e.isDeleted is null;
delete from entityname where (name=' ' or name='');
create index private.idx_entityname on entityname(id);

@ifPDF
	@column-sizes(1|6|6|1|1|2|2)
@end

select 
  en.code as CODE, 
  en.name as NAME, 
  en.generic as GENERIC,
  en.packsize as "SIZE@number",
  en.packing as "PK",
  en.sellingprice_pack as "PR@dividefactor",
  en.sellingprice_loose as "PR-EA@dividefactor"
from stock s
inner join types t on t.id=s.typeid
inner join private.entityname en on en.id=s.entityid
inner join stockQOH sq on sq.stockID=s.entityid
order by 2

