@ifPDF
	@column-sizes(1|2|6|2|1|2|2|1)
	@footer(||*|||sum||)
@end
select 
	id, 
	code as Code, 
	name as Name, 
	shelf as "Shelf",
	qoh as QOH, 
@ifExcel	
	stockvalue as "Stock Value@dividefactor@sum=sum", 
@ifPDF
	stockvalue as "Stock Value@dividefactor",
@end 
	expirydate as "Expiry Date@date", 
	shelf_life as "S/Life@number"
from (
	select 
		e.id as id, 
		gettoken(ef.content,0) as code, 
		gettoken(ef.content,1) as name, 
		(select group_concat(gettoken(ef.content,0)) from entityfts ef inner join entity e on e.docid=ef.rowid inner join EntityRelationship er on er.PairID=e.id where er.EntityID=e.id and er.typeID = (select value from ul_keys where key='entityRelationShelf')) as [shelf],
		formatqoh(s.entityID, getQOH(sq)) as qoh, 
		getQOH(sq)*sq.weightedAvgCost as "stockvalue", 
		earliestExpiryDate as expirydate, 
		sx.shelfLife as "shelf_life"
	from stock s
    inner join stockQOH sq on sq.stockID=s.entityID
	inner join StockExpiry sx on sx.stockid = s.entityid 
	inner join entity e on e.id=s.entityid 
	inner join entityfts ef on ef.rowid=e.docid  
	where s.isDeleted is NULL and sx.shelfLife <= @nmonth
) t order by shelf_life;
