@ifPDF
	@column-sizes(2|5|1|1|1|1)
	@break-page(0)
	@footer(|*||||sum)
@end

select * from (
select 
	=@groupby,
	gettoken(ef.content,1) as NAME, 
	getQOH(sq) as "QOH@number",
	sq.reorderLevel as "Reorder Level@number",
	weightedAvgCost as "COST@dividefactor", 
@ifPDF
	getQOH(sq)*weightedAvgCost as "VALUE@dividefactor"
@ifExcel
	getQOH(sq)*weightedAvgCost as "VALUE@dividefactor@sum=sum"
@end
from stock s
inner join stockQOH sq on sq.stockID=s.entityID
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
left join types t on t.id=s.typeID
where getQOH(sq) < sq.reorderLevel and s.isDeleted is NULL and gettoken(ef.content,1) > ''
) order by 1, 2;
