@ifPDF
	@column-sizes(1|1|4|1|1|1|1)
	@footer(||*||||sum)
@end

select * from (
select 
	(select group_concat(gettoken(ef.content,0)) from entityfts ef inner join entity e on e.docid=ef.rowid inner join EntityRelationship er on er.PairID=e.id where er.EntityID=e.id and er.typeID = (select value from ul_keys where key='entityRelationShelf')) as [SHELF],
	gettoken(ef.content,0) as CODE, 
	gettoken(ef.content,1) as NAME, 
	getQOH(sq)/(select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as "QOH@number",
	getQOH(sq)%(select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as "QOHL@number",
	weightedAvgCost as "COST@dividefactor", 
@ifPDF
	getQOH(sq)*weightedAvgCost as "VALUE@dividefactor"
@ifExcel
	getQOH(sq)*weightedAvgCost as "VALUE@dividefactor@sum=sum"
@end
from stock s
inner join stockQOH sq on sq.stockID=s.entityID
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
where getQOH(sq) < 0 and s.isDeleted is NULL
) order by shelf, name;
