@ifPDF
	@column-sizes(4|2|2|2|7|2|2|2|2)
	@footer(||||*|||sum|sum)
@end

select 
	cat.name as CATEGORY,
	sh.code as SHELF,
	(select group_concat(gettoken(ef.content,0)) from entityfts ef inner join entity e on e.docid=ef.rowid inner join EntityRelationship er on er.PairID=e.id where er.EntityID=e.id and er.typeID = (select value from ul_keys where key='entityRelationShelf')) as [SHELF],
	(select gettoken(content,0) from entityFTS where rowid=e.docID) as CODE, 
	(select gettoken(content,1) from entityFTS where rowid=e.docID) as NAME, 
	getQOH(sq)/(select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as "QOH@number",
	getQOH(sq)%(select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as "QOHL@number",
	weightedAvgCost as "COST@dividefactor", 
@ifExcel
	getQOH(sq)*weightedAvgCost as "VALUE@dividefactor@sum=sum"
@ifPDF
	getQOH(sq)*weightedAvgCost as "VALUE@dividefactor"
@end
from stock s
inner join stockQOH sq on sq.stockID=s.entityID
inner join entity e on e.id=s.entityid
left join entityrelationship er on er.entityid=e.id
left join types sh on sh.id=er.pairID
inner join types cat on cat.id=s.typeID
where exists(
	select * from receiveheader rh 
	inner join receivedetail rd on rd.receiveID=rh.id 
	where rh.isDeleted is NULL and rd.isDeleted is NULL and rd.stockid=s.entityid and rh.supplierID = @supplierid
)
order by 1,2,4

