@column-sizes(1|1|1|1)
@footer(||sum|)

select 'Sales' as "TYPE", date(sh.dateCreated/1000, 'unixepoch', 'localtime') as "DATE", -sd.quantity*sp.packsize as "QTY@number@sum=sum", sd.qoh as "QOH@number"
from salesdetail sd
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join salesheader sh on sh.id=sd.salesid
where sd.stockid = @stockid and sh.isDeleted is NULL and sd.isDeleted is NULL

union all

select 'Recv' as type, date(rh.dateCreated/1000, 'unixepoch', 'localtime') as date, rd.quantity*sp.packsize + ifnull(rd.bonusqty,0)*ifnull(spd.packsize,0) as qty, rd.quantity*sp.packsize + rd.bonusqty*spd.packsize as qoh
from receivedetail rd
inner join stockpackmaster sp on rd.stockid=sp.stockid and rd.packtypeid=sp.packtypeid
inner join stockpackmaster spd on rd.stockid=spd.stockid and rd.bonuspacktypeid=spd.packtypeid
inner join receiveheader rh on rh.id=rd.receiveid
where rd.stockid = @stockid and rh.isDeleted is NULL and rd.isDeleted is NULL

union all

select 'Adj' as type, date(rh.dateCreated/1000, 'unixepoch', 'localtime') as date, rd.quantity*sp.packsize as qty, rd.quantity*sp.packsize as qoh
from stocktransdetail rd
inner join stockpackmaster sp on rd.stockid=sp.stockid and rd.packtypeid=sp.packtypeid
inner join stocktransheader rh on rh.id=rd.stocktransid
where rd.stockid = @stockid and rh.isDeleted is NULL and rd.isDeleted is NULL
order by 2 
