@ifPDF
	@column-sizes(1|2|6|2|1|2|2|2|2)
	@footer(||*|||sum||)
@end

select 
	id, 
	code as Code, 
	name as Name, 
	shelf as "Shelf",
	qoh as QOH, 
@ifPDF
	stockvalue as "Stock Value@dividefactor", 
@ifExcel
	stockvalue as "Stock Value@dividefactor@sum=sum",
@end 
	earliestReceiveDate as "Received@date", 
	latestReceiveDate as "Latest Received@date", 
	age as "Age (mth)@number"
from (
	select 
		e.id as id, 
		gettoken(ef.content,0) as code, 
		gettoken(ef.content,1) as name, 
		(select group_concat(gettoken(ef.content,0)) from entityfts ef inner join entity e on e.docid=ef.rowid inner join EntityRelationship er on er.PairID=e.id where er.EntityID=e.id and er.typeID = (select value from ul_keys where key='entityRelationShelf')) as [shelf],
		formatqoh(e.id, getQOH(sq)) as qoh, 
		getQOH(sq)*sq.weightedAvgCost as "stockvalue", 
		earliestReceiveDate, latestReceiveDate,
		ageInStock as "age" 
	from stock s
    inner join stockQOH sq on sq.stockID=s.entityID
	inner join StockExpiry sx on sx.stockid = s.entityid 
	inner join entity e on e.id=s.entityid 
	inner join entityfts ef on ef.rowid=e.docid  
	where s.isDeleted is NULL and sx.ageInStock >= @nmonth
) t order by age desc;
