 @ifPDF
	@column-sizes(2|3|5|1|1|2|2|2)
	@footer(||*|||sum)

@end

select 
    t.name as "Type",
    h.transactionDate as "Date@datetime",
    space("[",gettoken(ef.content,0),"]", gettoken(ef.content,1)) as "Item",
    d.quantity as "Qty@integer",
    ifnull(sp.packdescription, '') as 'packing',
    d.costValue as "Cost@dividefactor",
    us.name as "Who",
    ifnull(ut.name, 'No Name') as "Terminal"
from stocktransheader h
inner join ul_sessions ses on ses.id=h.sessionID
inner join ul_terminals ut on ut.id=ses.terminalID
inner join ul_users us on us.id=ses.userID
inner join stocktransdetail d on d.stocktransid=h.id
inner join types t on t.id=d.typeid
inner join stock s on s.entityid=d.stockID
inner join stockpackmaster sp on sp.stockid=d.stockID and sp.packtypeid=d.packtypeid
inner join entity e on e.id=s.entityID
inner join entityfts ef on ef.rowid=e.docid
where s.isDeleted is NULL and e.isDeleted is NULL and quantity != 0
and h.transactionDate between @fromdate and @todate
order by gettoken(ef.content,1) 
