
drop table if exists private.entityname;

create table private.entityname as 
select 
  e.id,
  gettoken(ef.content,0) as code, 
  gettoken(ef.content,1) as name,
  (select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as packsize,
  (select packDescription from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as packing,
  latestCost as latestCost,
  weightedAvgCost as averageCost,
  (select sellingPrice from stockpack where stockid=s.entityid order by sellingPrice desc limit 1) as sellingPrice
from entityfts ef 
inner join entity e on e.docid=ef.rowid 
inner join stock s on s.entityid=e.id
inner join stockQOH sq on sq.stockid=s.entityid
where s.isDeleted is null and e.isDeleted is null;
delete from entityname where (code = " " or code = '') and (name=' ' or name='');
create index private.idx_entityname on entityname(id);

@ifPDF
	@column-sizes(1|4|1|1|1|1|1|1|4)
@end

select 
  en.code as CODE, 
  en.name as NAME, 
  en.packsize as "PACKSIZE@number",
  en.packing as "PACKING",
  getQOH(sq) as "QOH@number",
  en.latestCost as "LATEST-COST@dividefactor",
  en.sellingPrice as "PRICE@dividefactor",
  en.averageCost*sq.qoh as "TOTAL-COST@dividefactor",
  (
    select gettoken(ef.content,1) from entityfts ef
    inner join entity e on e.docid=ef.rowid
    inner join receiveheader rh on rh.supplierId=e.id and rh.isDeleted is null
    inner join receivedetail rd on rd.receiveId = rh.id and rd.stockid=s.entityId and rd.isDeleted is null
    order by rh.transactionDate desc limit 1
  ) as "SUPPLIER"
from stock s
inner join types t on t.id=s.typeid
inner join private.entityname en on en.id=s.entityid
inner join stockQOH sq on sq.stockID=s.entityid
order by 2

