@ifPDF
	@column-sizes(1|3|1)
@end

drop table if exists private.stockcode;
create table private.stockcode as
select
  gettoken(ef.content,0) as code,
  gettoken(ef.content,1) as name
from stock s
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
where s.isDeleted is NULL and e.isDeleted is NULL;

create index private.idx_stockcode on stockcode(code);

select distinct * from (
select 
  CODE, 
  NAME,
  (select count(*) from private.stockcode where code=s.code) as freq
from private.stockcode s
) t where freq > 1
order by 1,2;

