 @ifPDF
	@column-sizes(1|3|1|1|1|2)
@end

select 
	(select gettoken(content,0) from entityFTS ef inner join entity e on e.docid=ef.rowid where e.id=s.entityID) as CODE, 
	(select gettoken(content,1) from entityFTS ef inner join entity e on e.docid=ef.rowid where e.id=s.entityID) as NAME,
	formatqoh(s.entityID, q.qoh) as "QOH",
	sq.checkDate as "LASTCHECK@date",
	formatqoh(s.entityID, sq.qoh) as "QOH-Checked",
	us.name as "Who"
from stock s
inner join stockQOH q on q.stockID=s.entityID
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
inner join stockQOHCheck sq on sq.stockID=s.entityID
inner join ul_sessions ses on ses.id=sq.sessionID
inner join ul_users us on us.id=ses.userID
where s.isDeleted is NULL
order by 1,2,sq.checkDate desc

