@ifPDF
  @lineheight(4)
  @font(Arial,,7)
  @footer(|||*|||sum|sum)
  @column-sizes(10|10|10|60|10|10|15|15)
@end

select 
  cat.name as CATEGORY,
		(select group_concat(gettoken(ef.content,0)) from entityfts ef inner join entity e on e.docid=ef.rowid inner join EntityRelationship er on er.PairID=e.id where er.EntityID=e.id and er.typeID = (select value from ul_keys where key='entityRelationShelf')) as [shelf],
  gettoken(ef.content,0) as CODE, 
  gettoken(ef.content,1) as NAME, 
  getQOH(sq)/(select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as "QOH@number",
  getQOH(sq)%(select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as "QOHL@number",
  weightedAvgCost as "COST@dividefactor", 
  getQOH(sq)*weightedAvgCost as "VALUE@dividefactor@sum=sum"
from stock s
inner join stockQOH sq on sq.stockID=s.entityID
inner join entity e on e.id=s.entityid
inner join types cat on cat.id=s.typeID
inner join entityfts ef on ef.rowid=e.docid
where s.isDeleted is NULL and e.isDeleted is NULL 
and (agemonth(case when ifnull(sq.latestReceiveDate,0) < ifnull(sq.latestSalesDate,0) then sq.latestSalesDate else sq.latestReceiveDate end) < 24 or getQOH(sq) != 0)
order by 1,3

