
drop table if exists private.entityname;

-- 0: code,
-- 1: name,
-- 2: regNo,
-- 3: colour,
-- 4: detail,
-- 5: barCode,
-- 6: brand,
-- 7: genericName,
-- 8: strength,
-- 9: remark,
-- 10: alternateName,
-- 11: additionalPacking,

drop table if exists private.poisontype;
drop table if exists private.entityname;

create table private.poisontype as select * from types where parentid=(select value from ul_keys where key ='ScheduleTypeGroupID');
create index private.idx_poisontype on poisontype(id);
create table private.entityname as 
select 
  e.id,
  gettoken(ef.content,0) as code, 
  gettoken(ef.content,1) as name,
  gettoken(ef.content,2) as regNo,
  gettoken(ef.content,5) as barcode,
  gettoken(ef.content,6) as brand,
  gettoken(ef.content,7) as generic,
  (select name from types where id=s.typeID) as category,
  (select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as packsize,
  (select packDescription from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as packing,
  (select sellingPrice from stockpack where stockid=s.entityid order by sellingPrice desc limit 1) as sellingprice_pack,
  (select sellingPrice from stockpack where stockid=s.entityid order by sellingPrice limit 1) as sellingprice_loose,
  (select weightedAvgCost from stockqoh where stockid=s.entityid) as weightedAvgCost_loose,
  (select latestCost from stockqoh where stockid=s.entityid) as latestCost_loose,
  case when s.ispseudopoison then 'PSEUDO' when s.ispoison then 'POISON' end as poison,
  case when s.ispoison OR s.ispseudopoison then (select t.code from entityattributes ea inner join poisontype t on t.id=ea.typeID where ea.entityid=e.id) end as poisonclassification
from entityfts ef 
inner join entity e on e.docid=ef.rowid 
inner join stock s on s.entityid=e.id
where s.isDeleted is null and e.isDeleted is null;
delete from entityname where (code = " " or code = '') and (name=' ' or name='');
create index private.idx_entityname on entityname(id);

@ifPDF
	@column-sizes(2|1|4|2|2|1|1|1|1|1|1|1)
@end

select 
  en.category as CATEGORY,
  en.code as CODE, 
  en.name as NAME, 
  en.brand as BRAND, 
  en.barcode as BARCODE,
  en.poison as POISON,
  en.poisonclassification as CLASS,
  en.packsize as "PACKSIZE@number",
  en.weightedAvgCost_loose*en.packsize as "AVG COST@dividefactor",
  en.latestCost_loose*en.packsize as "LATEST COST@dividefactor",
  en.sellingprice_pack as "PRICE PACK@dividefactor",
  en.sellingprice_loose as "PRICE LS@dividefactor"
from stock s
inner join private.entityname en on en.id=s.entityid
inner join stockQOH sq on sq.stockID=s.entityid
order by 3

