 @ifPDF
	@column-sizes(1|4|1|1|3|1|1|1|1)
@end

select 
    (select gettoken(content,0) from entityfts where rowid=e.docid) as CODE,
    (select gettoken(content,1) from entityfts where rowid=e.docid) as NAME,
	(select group_concat(gettoken(eef.content,0)) from entityfts eef inner join entity ee on ee.docid=eef.rowid inner join LocalEntityRelationship eer on eer.PairID=ee.id where entityfts match 'shelf' and eer.EntityID=e.id and eer.typeID = (select value from ul_keys where key='entityRelationShelf')) as [SHELF],
    formatqoh(s.entityID, getQOH(sq)) as "QOH",
    (select gettoken(content,1) from entityfts efs inner join entity e on e.docid=efs.rowid where e.id=rh.supplierid) as SUPPLIER,
    rh.refNo as "INVOICE NO",
    rd.batchNo as "BATCH NO",
    rd.expiryDate as "EXPIRY@date",
    formatqoh(s.entityID, rd.quantity * ifnull(sp.packsize,1) + ifnull(rd.bonusQty,0)*ifnull(spb.packsize, 1)) as "QTY-PURC"
from stock s
inner join entity e on e.id=s.entityid
inner join stockqoh sq on sq.stockid=s.entityid
left join receivedetail rd on rd.stockid=s.entityid 
left join receiveheader rh on rh.id = rd.receiveid
inner  join stockpackmaster sp on (rd.stockid=sp.stockid and rd.packtypeid=sp.packtypeid)
inner  join stockpackmaster spb on (rd.stockid=spb.stockid and rd.bonuspacktypeid=spb.packtypeid)
where e.isDeleted is NULL and sq.qoh > 0 and rd.isDeleted is NULL and rh.isDeleted is NULL and rd.qoh > 0
order by 3,2,1,6;

-- 