@column-sizes(1|2|1|1|1|1)
@footer(||sum|sum|sum|sum)
select 
    Type,
    date as "Date@datetime",
    Quantity as "Q-In@number@sum=sum",
    Value as "V-In@dividefactor@sum=sum",
    QOut as "Q-Out@number@sum=sum",
    VOut as "V-Out@dividefactor@sum=sum"
from (
    select 
        "IN" as Type, 
        transactiondate as Date, 
        quantity*ifnull(sp.packsize,1)+ifnull(bonusqty,0)*ifnull(spb.packsize,1) as Quantity, 
        price*quantity as Value, 
        0 as QOut, 
        0 as VOut
    from receivedetail rd
    inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
    inner join stockpackmaster spb on spb.stockid=rd.stockid and spb.packtypeid=rd.bonuspacktypeid 
    inner join receiveheader rh on rh.id=rd.receiveid 
    where rd.stockID = @stockid and rh.isDeleted is NULL and rd.IsDeleted is NULL
union all
    select 
        "HOLD-IN" as Type, 
        transactiondate as Date, 
        quantity*ifnull(sp.packsize,1)+ifnull(bonusqty,0)*ifnull(spb.packsize,1) as Quantity, 
        price*quantity as Value, 
        0 as QOut, 
        0 as VOut
    from suspendedreceivedetail rd
    inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
    inner join stockpackmaster spb on spb.stockid=rd.stockid and spb.packtypeid=rd.bonuspacktypeid 
    inner join suspendedreceiveheader rh on rh.id=rd.receiveid 
    where rd.stockID = @stockid and rh.isDeleted is NULL and rd.IsDeleted is NULL
union all
    select 
        "OUT", 
        transactiondate, 
        0,
        0,
        quantity*ifnull(sp.packsize,1) as Quantity, 
        price*quantity 
    from salesdetail rd 
    inner join salesheader rh on rh.id=rd.salesid 
    inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
    where rd.stockID = @stockid and rh.isDeleted is NULL and rd.IsDeleted is NULL
union all
    select 
        "HOLD-OUT", 
        transactiondate, 
        0,
        0,
        quantity*ifnull(sp.packsize,1) as Quantity, 
        price*quantity 
    from suspendedsalesdetail rd 
    inner join suspendedsalesheader rh on rh.id=rd.salesid 
    inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
    where rd.stockID = @stockid and rh.isDeleted is NULL and rd.IsDeleted is NULL
union all
    select "ADJ", 
        transactionDate, 
        (case when quantity >= 0 then quantity*ifnull(sp.packsize,1) else 0 end), 
        (case when quantity >= 0 then costValue else 0 end), 
        (case when quantity < 0 then quantity*ifnull(sp.packsize,1) else 0 end), 
        (case when quantity < 0 then costValue else 0 end) 
    from stocktransdetail rd 
    inner join stocktransheader rh on rh.id=rd.stocktransID 
    inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
    where rd.stockID = @stockid and rh.isDeleted is NULL and rd.IsDeleted is NULL
) t order by date
