 @ifPDF
	@column-sizes(2|15|1|2|3|3|3|3|4)
@end

select 
	(select gettoken(content,0) from entityFTS ef inner join entity e on e.docid=ef.rowid where e.id=s.entityID) as CODE, 
	(select gettoken(content,1) from entityFTS ef inner join entity e on e.docid=ef.rowid where e.id=s.entityID) as NAME,
	(select code from Types t where p.packtypeid=t.id) as 'Pack',
    sp.packdescription as 'Packing',
    p.dateCreated as 'Date@date',
    p.dateCreated as 'Time@time',
	p.oldPrice as "Old Price@dividefactor",
    p.newPrice as "New Price@dividefactor",
	us.name as "Who"
from StockPackPriceChanges p 
inner join stock s on p.stockID=s.entityID
inner join StockPackMaster sp on sp.stockid=p.stockid and sp.packtypeid=p.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
inner join ul_sessions ses on ses.id=p.sessionID
inner join ul_users us on us.id=ses.userID
where p.dateCreated between @fromdate and @todate
order by 1,2
