
drop table if exists private.entityname;

create table private.entityname as 
select 
  e.id,
  gettoken(ef.content,0) as code, 
  gettoken(ef.content,1) as name,
  (select packsize from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as packsize,
  (select packDescription from stockpackmaster where stockid=s.entityid order by packsize desc limit 1) as packing,
  (select sellingPrice from stockpack where stockid=s.entityid order by sellingPrice desc limit 1) as sellingprice_pack,
  (select sellingPrice from stockpack where stockid=s.entityid order by sellingPrice limit 1) as sellingprice_loose
from entityfts ef 
inner join entity e on e.docid=ef.rowid 
inner join stock s on s.entityid=e.id
where s.isDeleted is null and e.isDeleted is null;
delete from entityname where (code = " " or code = '') and (name=' ' or name='');
create index private.idx_entityname on entityname(id);

@ifPDF
	@column-sizes(2|1|4|1|1|1|1|1|1)
@end

select 
  t.name as CATEGORY,
  en.code as CODE, 
  en.name as NAME, 
  en.packsize as "PACKSIZE@number",
  en.packing as "PACKING",
  getQOH(sq) as "QOH@number",
  en.sellingprice_pack as "PRICE@dividefactor",
  en.sellingprice_loose as "PRICE-L@dividefactor",
  weightedAvgCost as "COST@dividefactor",
  cast(en.sellingprice_loose-weightedAvgCost as real)/cast(case when weightedAvgCost=0 then 0.001 else weightedAvgCost end as real)*100.0 as "+OVER_COST@decimal"
from stock s
inner join types t on t.id=s.typeid
inner join private.entityname en on en.id=s.entityid
inner join stockQOH sq on sq.stockID=s.entityid
order by 1,3

