drop table if exists private.stkmvmt;
create table private.stkmvmt as 
    select
       gettoken(ef.content, 0) as code,
       gettoken(ef.content, 1) as name,
       (select sum(q) from StockOpen where stockID=s.entityID) as qOpen,
       (select sum(q) from StockIn where stockID=s.entityID) as qIn,
       (select sum(q) from StockAdjust where stockID=s.entityID) as qAdj,
       (select sum(q) from StockOut where stockID=s.entityID) as qOut,
       (select sum(q) from StockClose where stockID=s.entityID) as qClose,
       (select sum(v) from StockOpen where stockID=s.entityID) as costOpen,
       (select sum(v) from StockIn where stockID=s.entityID) as costIn,
       (select sum(v) from StockAdjust where stockID=s.entityID) as costAdj,       
       (select sum(v) from StockOut where stockID=s.entityID) as costOut,
       (select sum(v) from StockClose where stockID=s.entityID) as costClose
    from stock s
    inner join entity e on e.id=s.entityID
    inner join entityfts ef on ef.rowid=e.docid
    where s.isDeleted is NULL and e.IsDeleted is NULL;

-- alter table private.stkmvmt add qClose integer;
-- alter table private.stkmvmt add costClose integer;

-- update private.stkmvmt set
--     qClose = ifnull(qOpen,0)+ifnull(qIn,0)+ifnull(qAdj,0)-ifnull(qOut,0),
--     costClose = ifnull(costOpen,0)+ifnull(costIn,0)+ifnull(costAdj,0)-ifnull(costOut,0);

-- update private.stkmvmt set costClose=0 where qClose=0 or (qClose>0 and costClose<0) or (qClose < 0 and costClose > 0);
-- update private.stkmvmt set costOpen=0 where qOpen=0 or (qOpen>0 and costOpen<0) or (qOpen < 0 and costOpen > 0);

@lineheight(4)
@font(Arial,,7)
@footer(||||||sum|sum|sum|sum||sum)
@column-sizes(2|9|1|1|1|1|2|2|2|2|1|2)

select 
   code as Code,
   name as Name,
   qOpen as "Q Start@integer",
   qIn as "Q In@integer",
   qOut as "Q Out@integer",
   qAdj as "Q Adj@integer",
   costOpen as "Cost Open@dividefactor",
   costIn as "Cost In@dividefactor",
   costOut as "Cost Out@dividefactor",
   costAdj as "Cost Adj@dividefactor",
   qClose as "Q Close@integer",
   costClose as "Cost Close@dividefactor"
from private.stkmvmt
where qOpen <> 0 or qIn <> 0 or qOut <> 0
order by name;
