select 
 entityid, 
 (select max(transactiondate) as tdate from receiveheader rh inner join receivedetail rd on rh.id=rd.receiveid where rd.stockid=t.entityid) as maxrecv, 
 (select max(transactiondate) as tdate from salesheader rh inner join salesdetail rd on rh.id=rd.salesid where rd.stockid=t.entityid) as maxsales,
 maxdate, date(maxdate/1000, 'unixepoch', 'localtime') as latestdate from (
 select 
  entityid,
  (
   select max(tdate) from (
     select max(transactiondate) as tdate from receiveheader rh inner join receivedetail rd on rh.id=rd.receiveid where rd.stockid=s.entityid 
     union 
     select max(transactiondate) as tdate from salesheader rh inner join salesdetail rd on rh.id=rd.salesid where rd.stockid=s.entityid
   ) t
 ) as maxdate
from stock s
) t limit 20;