select 
   name as "DATE", 
   sum(sales) as "SALES@dividefactor@sum=sum", 
   sum(roundingAmount) as "Rounding@dividefactor@sum=sum", 
   sum(discountAtTotal) as "Discount@dividefactor@sum=sum", 
   sum(payment) as "PAYMENT@dividefactor@sum=sum", 
   sum(sales-payment) as "DIFF@dividefactor@sum=sum"
from (
	select 
	  c.id, c.name, weekNo,
	  (select sum(amount) from salesdetail where salesid=sh.id and isdeleted is null) as sales,
	  (select sum(paidAmount) from paymentreceived where salesid=sh.id and isdeleted is null) as payment,
	  discountAtTotal,
	  roundingAmount
	from salesheader sh 
	inner join calendar c on sh.transactionDate > c.fromDate and sh.transactionDate < c.toDate
	where sh.transactionDate between @fromdate and @todate and sh.isdeleted is null
	and c.type='DAY'
) t 
group by name
order by weekNo;



select 
   id as "SALESID", 
   sales as "SALES@dividefactor@sum=sum", 
   roundingAmount as "Rounding@dividefactor@sum=sum", 
   discountAtTotal as "Discount@dividefactor@sum=sum", 
   payment as "PAYMENT@dividefactor@sum=sum", 
   sales-payment as "DIFF@dividefactor@sum=sum",
   transactionDate as "DATE@date"
from (
	select 
	  sh.id,
	  (select sum(amount) from salesdetail where salesid=sh.id and isdeleted is null) as sales,
	  (select sum(paidAmount) from paymentreceived where salesid=sh.id and isdeleted is null) as payment,
	  discountAtTotal,
	  roundingAmount,
	  sh.transactionDate
	from salesheader sh 
	inner join calendar c on sh.transactionDate > c.fromDate and sh.transactionDate < c.toDate
	where sh.transactionDate between @fromdate and @todate and sh.isdeleted is null
	and c.type='DAY'
) t 
where abs(sales-payment) > 10000;

