attach "ppos.db" as ppos;
.header on
.sep "\t"
.out "mismatch_invoice.csv"

update ppos.items set packsize=1 where packsize is null or packsize=0;

select i.code as code, i.name as name, i.qoh as qoh, i.packsize as packsize, r.*, ppos-new as diff from (
select entityid as id, fcc, 
 (select sum(
           case when d.ls='L' then qty else qty*packsize end +
           case when d.loose='L' then bonus else bonus*packsize end
         ) as total
  from ppos.invd d
  inner join ppos.inv h on h.fcc=d.fcc and h.date=d.date
  inner join ppos.items itm on itm.fcc=d.item
  where h._isDeleted is null and d.item=m.fcc) as PPOS,

 (select sum(quantity*sp.packsize+ifnull(bonusQty,0)*ifnull(spb.packsize,1)) as total
  from receivedetail d
  inner join stockpackmaster sp on sp.stockid=d.stockid and sp.packtypeid=d.packtypeid
  inner join stockpackmaster spb on spb.stockid=d.stockid and spb.packtypeid=d.bonuspacktypeid
  where d.stockid=m.entityid) as NEW
from stock m
inner join stockQOH sq on sq.stockID=m.entityID
) r
inner join ppos.items i on i.fcc=r.fcc
where ppos-new <> 0;

.out "mismatch_sales.csv"

select i.code as code, i.name as name, i.qoh as qoh, i.packsize as packsize, r.*, ppos-new as diff from (
select entityid as id, fcc, 
 (select sum(
           (case when d.type in (4,5) then -1 else 1 end)*(case when d.loose='L' then qty else qty*packsize end)
         ) as total
  from ppos.accposd d
  inner join ppos.accpos h on h.fcc=d.fcc and h.date=d.date
  inner join ppos.items itm on itm.fcc=d.item
  where h._isDeleted is null and d.item=m.fcc) as PPOS,

 (select sum(quantity*sp.packsize) as total
  from salesdetail d
  inner join stockpackmaster sp on sp.stockid=d.stockid and sp.packtypeid=d.packtypeid
  where d.stockid=m.entityid) as NEW
from stock m
inner join stockQOH sq on sq.stockID=m.entityID
) r
inner join ppos.items i on i.fcc=r.fcc
where ppos-new <> 0;

.out "mismatch_qoh.csv"

select i.code as code, i.name as name, i.qoh as qoh, i.packsize as packsize, r.*, ppos-new as diff from (
  select entityid as id, fcc, 
   (select qoh*packsize+qohl from ppos.items where fcc=m.fcc) as PPOS,
   (select sum(qoh) as total from stockcost where stockid=m.entityid) as NEW
  from stock m
) r
inner join ppos.items i on i.fcc=r.fcc
where ppos-new <> 0;


.out "mismatch_stkmvmt.csv"

select i.code as code, i.name as name, i.qoh as qoh, i.packsize as packsize, r.*, ppos-new as diff from (
  select entityid as id, fcc, 
   (select sum(qty*(case when loose='L' then 1 else packsize end)) from ppos.stkmvmt d 
    inner join ppos.items x on x.fcc=d.item where type not in (2,4,6,7) and x.fcc=m.fcc) as PPOS,
   (select sum(quantity*sp.packsize) as total from stocktransdetail d
    inner join stockpackmaster sp on sp.stockid=d.stockid and sp.packtypeid=d.packtypeid where d.stockid=m.entityid) as NEW
  from stock m
  inner join stockQOH sq on sq.stockID=m.entityID
) r
inner join ppos.items i on i.fcc=r.fcc
where ppos-new <> 0;
