begin;

select "Before: No of distinct stock = " || count(*) from (
 select distinct substr(ef.content,1,4) as code
 from entityfts ef
 inner join entity e on e.docid=ef.docid
 inner join stock s on s.entityid=e.id
) t;

select "Before: No of duplicate stock = " || count(*) from (
 select substr(ef.content,1,4) as code
 from entityfts ef
 inner join entity e on e.docid=ef.docid
 inner join stock s on s.entityid=e.id
 group by substr(ef.content,1,4)
 having count(*) > 1
) t; 

create table distinctcode_before as 
 select distinct substr(ef.content,1,4) as code
 from entityfts ef
 inner join entity e on e.docid=ef.docid
 inner join stock s on s.entityid=e.id;
 
drop table if not exists dupcode;

create table dupcode as
 select substr(ef.content,1,4) as code
 from entityfts ef
 inner join entity e on e.docid=ef.docid
 inner join stock s on s.entityid=e.id
 group by substr(ef.content,1,4)
 having count(*) > 1;

create index idx_dupcode_id on dupcode(code);

drop table if exists dupcode_ids;
create table dupcode_ids as 
select 
    substr(ef.content,1,4) as code, s.entityID, e.docID,
    ifnull((select sd.salesid from salesdetail sd where sd.stockid=s.entityid and sd.isDeleted is NULL limit 1),'NOT EXIST') as InSales,
    ifnull((select sd.receiveid from receivedetail sd where sd.stockid=s.entityid and sd.isDeleted is NULL limit 1),'NOT EXIST') as InInv,
    ifnull((select sd.stocktransid from stocktransdetail sd where sd.stockid=s.entityid and sd.isDeleted is NULL limit 1),'NOT EXIST') as InAdj
from stock s
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.docid=e.docid
where exists(select * from dupcode where code=substr(ef.content,1,4))
order by substr(ef.content,1,4), ef.docid;

delete from stock where entityid in (select distinct entityID from dupcode_ids where insales='NOT EXIST' and ininv='NOT EXIST');
delete from entity where id in (select distinct entityID from dupcode_ids where insales='NOT EXIST' and ininv='NOT EXIST');
delete from entityfts where docid in (select docid from dupcode_ids where insales='NOT EXIST' and ininv='NOT EXIST');

select "After: No of distinct stock = " || count(*) from (
 select distinct substr(ef.content,1,4) as code
 from entityfts ef
 inner join entity e on e.docid=ef.docid
 inner join stock s on s.entityid=e.id
) t;

select "After: No of duplicate stock = " || count(*) from (
 select substr(ef.content,1,4) as code
 from entityfts ef
 inner join entity e on e.docid=ef.docid
 inner join stock s on s.entityid=e.id
 group by substr(ef.content,1,4)
 having count(*) > 1
) t; 

create table distinctcode_after as 
 select distinct substr(ef.content,1,4) as code
 from entityfts ef
 inner join entity e on e.docid=ef.docid
 inner join stock s on s.entityid=e.id;

commit;
