select @fromdate as "FROM Date", @todate as "TO Date";


select "TOTAL BRAND'S SALES" as "";

select 
	cat as CATEGORY,
    code as CODE,
    name as NAME,
    "" as "Internal Date",
    "" as "Date",    
	sum(qty) as "QTY@integer", 
	sum(value) as "VALUE@dividefactor@sum=sum", 
	sum(cost) as "COST@dividefactor@sum=sum", 
	sum(value-cost) as "GROSS@dividefactor@sum=sum",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@decimal" 
from (
select  
   cat.name as cat,
   gettoken(ef.content,0) as code,
   gettoken(ef.content,1) as name,
   quantity*ifnull(packsize,1) as qty, 
   quantity*price as value,
   quantity*sp.packsize*costprice as cost 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join types cat on cat.id=s.typeid
inner join master sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.docid=e.docid
where e.id=@stockID and transactionDate >= @fromdate and transactionDate <= @todate 
) t 
group by cat, code, name
order by 1;

select "SAME AS ABOVE - DETAIL LINE" as "";

select 
   cat.name as cat,
   gettoken(ef.content,0) as code,
   gettoken(ef.content,1) as name,
   transactionDate as 'Internal Date',
   date(transactionDate/1000, 'unixepoch', 'localtime') as 'Date',
   quantity*ifnull(packsize,1) as "QTY@integer", 
   quantity*price as "VALUE@dividefactor@sum=sum",
   quantity*sp.packsize*costprice as "COST@dividefactor@sum=sum" 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join types cat on cat.id=s.typeid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.docid=e.docid
where e.id=@stockID and transactionDate >= @fromdate and transactionDate <= @todate; 

