    create temp table if not exists StockMovement(type integer, month text, qty integer);
    create index if not exists idx_stkmvmt_0 on StockMovement(month, type);
    delete from StockMovement;

	insert into StockMovement (type, month, qty) 
	select 
	   1 as Type, 
	   strftime('%Y-%m', datetime(rh.transactiondate/1000, 'unixepoch', 'localtime')) as YYYYMM, 
	   sum(quantity*(case when sp.packsize=0 or sp.packsize='' or sp.packsize is NULL then 1 else sp.packsize end) + 
		   ifnull(bonusQty,0)*(case when spb.packsize=0 or spb.packsize='' or spb.packsize is NULL then 1 else spb.packsize end)) as Qty 
	from ReceiveDetail rd 
	inner join ReceiveHeader rh on rd.receiveID=rh.id 
	inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
	inner join stockpackmaster spb on spb.stockid=rd.stockid and spb.packtypeid=rd.bonuspacktypeid 
	where rd.stockid=8857 group by 2;

	insert into StockMovement (type, month, qty) 
	select 
	   2 as Type, 
	   strftime('%Y-%m', datetime(rh.transactiondate/1000, 'unixepoch', 'localtime')) as YYYYMM, 
	   sum(quantity * (case when packsize=0 or packsize='' or packsize is NULL then 1 else packsize end)) as Qty 
	from SalesDetail rd 
	inner join SalesHeader rh on rd.salesid=rh.id 
	inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
	where rd.stockid=8857 group by 2;

	insert into StockMovement (type, month, qty) 
	select 
	   3 as Type, 
	   strftime('%Y-%m', datetime(rh.transactiondate/1000, 'unixepoch', 'localtime')) as YYYYMM, 
	   sum(quantity * (case when packsize=0 or packsize='' or packsize is NULL then 1 else packsize end)) as Qty 
	from StockTransDetail rd 
	inner join StockTransHeader rh on rd.stocktransid=rh.id 
	inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
	where rd.stockid=? group by 2;

	select 
	  month, 
	  sum(case when type=1 then qty else 0 end) as QtyIn, 
	  sum(case when type=2 then qty else 0 end) as qtyOut, 
	  sum(case when type=3 then qty else 0 end) as qtyAdj 
	from StockMovement group by month order by month desc;
