select "Items where QOH does not tally with transactions.";
select * from (
  select 
    s.entityid,
    qoh, 
    (select sum(quantity*packsize) from salesdetail sd inner join stockpackmaster sp on sp.stockid=s.entityid and sp.packtypeid=sd.packtypeid where sd.stockid=s.entityid) as qty_out, 
    (select sum(quantity*packsize) from receivedetail sd inner join stockpackmaster sp on sp.stockid=s.entityid and sp.packtypeid=sd.packtypeid where sd.stockid=s.entityid) as qty_in,
    (select sum(bonusQty*packsize) from receivedetail sd inner join stockpackmaster sp on sp.stockid=s.entityid and sp.packtypeid=sd.bonuspacktypeid where sd.stockid=s.entityid) as bonusqty_in, 
    (select sum(quantity*packsize) from stocktransdetail sd inner join stockpackmaster sp on sp.stockid=s.entityid and sp.packtypeid=sd.packtypeid where sd.stockid=s.entityid) as qty_delta 
  from stock s
  inner join stockQOH sq on sq.stockID=s.entityID
) t where qoh != ((qty_in+bonusqty_in+qty_delta) - qty_out);

select "--- end of list ---";

select s.entityid,
   qoh, 
   (select sum(quantity*packsize) from salesdetail sd inner join stockpackmaster sp on sp.stockid=s.entityid and sp.packtypeid=sd.packtypeid where sd.stockid=s.entityid) as qty_out, 
   (select sum(quantity*packsize) from receivedetail sd inner join stockpackmaster sp on sp.stockid=s.entityid and sp.packtypeid=sd.packtypeid where sd.stockid=s.entityid) as qty_in,
   (select sum(bonusQty*packsize) from receivedetail sd inner join stockpackmaster sp on sp.stockid=s.entityid and sp.packtypeid=sd.bonuspacktypeid where sd.stockid=s.entityid) as bonusqty_in, 
   (select sum(quantity*packsize) from stocktransdetail sd inner join stockpackmaster sp on sp.stockid=s.entityid and sp.packtypeid=sd.packtypeid where sd.stockid=s.entityid) as qty_delta 
from stock s
inner join stockQOH sq on sq.stockID=s.entityID;