select 
	code as CODE, 
	name as NAME, 
	sum(qty) as "QTY@integer", 
	sum(value) as "VALUE@dividefactor", 
	sum(cost) as "COST@dividefactor", 
	sum(value-cost) as "GROSS@dividefactor",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@number" 
from (
select  
   gettoken(ef.content,0) as code,
   gettoken(ef.content,1) as name, 
   quantity*ifnull(packsize,1) as qty, 
   quantity*price as value,
   quantity*round(costprice,2) as cost 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.docid=e.docid
where transactionDate between @fromdate and @todate
) t 
group by code, name
order by 4 desc;


select 
	code as CODE, 
	name as NAME, 
	sum(qty) as "QTY@integer", 
	sum(value) as "VALUE@dividefactor", 
	sum(cost) as "COST@dividefactor", 
	sum(value-cost) as "GROSS@dividefactor",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@number" 
from (
select  
   gettoken(ef.content,0) as code,
   gettoken(ef.content,1) as name, 
   quantity*ifnull(packsize,1) as qty, 
   quantity*price as value,
   quantity*round(costprice,2) as cost 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join master sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.docid=e.docid
where transactionDate between @fromdate and @todate
) t 
group by code, name
order by 6 desc;

select 
	code as CODE, 
	name as NAME, 
	sum(qty) as "QTY@integer", 
	sum(value) as "VALUE@dividefactor", 
	sum(cost) as "COST@dividefactor", 
	sum(value-cost) as "GROSS@dividefactor",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@number" 
from (
select  
   gettoken(ef.content,0) as code,
   gettoken(ef.content,1) as name, 
   quantity*ifnull(packsize,1) as qty, 
   quantity*price as value,
   quantity*round(costprice,2) as cost 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.docid=e.docid
where transactionDate between @fromdate and @todate
) t 
group by code, name
order by 7 desc;
