
@ifPDF
	@column-sizes(8|8|8|8|15|2|3|3|7)
	@footer(||||*||sum|sum|)
@end

select  
   sh.transactionDate as "Transaction Date@datetime",
   sh.dateCreated as "System Date@datetime",
   (select dateDeleted from deletedPurchase where receiveid = sh.id) as "Deleted On@datetime",
   (select gettoken(content, 0) from entityFTS where rowid=es.docID)||'/'||sh.refno as "Invoice No",
   (select gettoken(content,1) from entityFTS where rowid=e.docID) as "Item Purchased",
   sd.quantity||pt.code as "Q@integer",
   amount as "Amount@dividefactor@sum=sum",
   amount-sd.quantity*price as "GST@dividefactor",
   us.name as "Who Delete"
from receiveheader sh
inner join receivedetail sd on sd.receiveid=sh.id
inner join stock st on st.entityid=sd.stockid
inner join stockpackmaster sp on sp.stockID=sd.stockID and sp.packTypeID=sd.packTypeID
inner join types pt on pt.id=sd.packtypeID
inner join entity e on e.id=sd.stockid
inner join ul_sessions sdel on sh.sessionid=sdel.id
inner join ul_users us on us.id=sdel.userid
inner join entity es on es.id=sh.supplierid
where sh.transactionDate between @fromdate and @todate and (sh.isdeleted = 1 or sh.id in (select receiveid from deletedpurchase))
order by sh.transactionDate desc