@ifExcel
	@removedup(0,1,2)
@ifPDF
	@column-sizes(1|2|2|4|2|2|2|2)
	@footer(|||*|sum|sum|sum|sum|sum)
@end

select 
	rh.id as INVOICE,
	rh.refNo as REFNO,
	rh.transactionDate as "DATE@date",
	(select gettoken(content,1) from entityFTS where rowid=e.docID) as SUPPLIER,
	sum(case when s.gstcode=(select value from ul_keys where key = 'GSTMarker') then rd.quantity*rd.price else 0 end) as "SR@dividefactor@sum=sum",
	sum(case when s.gstcode!=(select value from ul_keys where key = 'GSTMarker') then rd.quantity*rd.price else 0 end) as "Non-SR@dividefactor@sum=sum",
	sum(rd.taxAmount) as "GST@dividefactor@sum=sum",
	sum(rd.amount) as "TOTAL@dividefactor@sum=sum"
from receiveheader rh
inner join receivedetail rd on rd.receiveid=rh.id
inner join entity e on e.id=rh.supplierID
inner join stock s on rd.stockID = s.entityID
where rh.IsDeleted is NULL and rd.isDeleted is NULL and s.IsDeleted is NULL and rh.transactionDate between @fromdate and @todate
and rd.amount < 0
group by rh.id
order by 4, rh.transactionDate;
