@ifPDF
	@column-sizes(3|3|3|2|2|2|2|2)
	@footer(||*|sum|sum|sum|sum|sum)
@end

select 
  salesType as 'SALES TYPE',
  strftime('%Y-%m', date(date/1000,'unixepoch', 'localtime')) as 'MONTH', 
  prt.name as 'PAID BY',
  sum(effectiveAmount) as 'PAID AMOUNT@dividefactor@sum=sum', 
  sum(case when effectiveGST=0 then effectiveAmount else 0 end) as 'ZR@dividefactor@sum=sum',
  sum(case when effectiveGST!=0 then effectiveAmount-effectiveGST else 0 end) as 'SR@dividefactor@sum=sum',
  sum(effectiveGST) as 'GST@dividefactor@sum=sum',
  sum(effectiveAmount) as 'AMOUNT@dividefactor@sum=sum'
from DailySalesSummaryByCategory sh
inner join paymentreceived pr on pr.salesid=sh.id
inner join types prt on prt.id = pr.paidBy
where prt.id not in (select value from ul_keys where key='PayByCash' or key='PayByCashOut' or key='PayByPoints') 
group by 1, 2, 3
order by 1, 2, 3;