-- dependency on temp table DailySalesSummaryByCategory(id, date, salesType, category, valueWithGST, costWithoutGST, gst)
-- generated by command-before='generatedailysalessummarybycategory' in the ServerSideMenu.xml for the definition of the job 
-- using filter userParam="salesType in (select value from ul_keys where key='CashSalesType')"

@footer(|*|sum|sum|sum|sum|sum|c[6]/c[3]*100)
@row-function(|||||||c[6]/c[3]*100)
select 
	'DAILY SALES' as 'REPORT',
	salesType as 'TYPE', 
	sum(gst) as "GST@dividefactor", 
    sum(valueWithGST-gst) as "VALUE@dividefactor", 
    sum(valueWithGST) as "COLLECTION@dividefactor", 
	sum(costWithoutGST) as "COST@dividefactor", 
	sum(valueWithGST-gst-costWithoutGST) as "GROSS@dividefactor",
	0 as "MARGIN@decimal" 
from DailySalesSummaryByCategory
group by salesType    
order by 2;

@clear
@footer(|*|sum|sum|sum|sum|sum|c[6]/c[3]*100)
@row-function(|||||||c[6]/c[3]*100|)
select  
    salesType as "TYPE",
    strftime('%Y-%m-%d', date(t.date/1000,'unixepoch', 'localtime')) ||' '|| getdayname(strftime('%w', date(t.date/1000,'unixepoch', 'localtime'))) as "DAY", 
    sum(gst) as "GST@dividefactor", 
    sum(valueWithGST-gst) as "VALUE@dividefactor", 
    sum(valueWithGST) as "COLLECTION@dividefactor", 
    sum(costWithoutGST) as "COST@dividefactor", 
	sum(valueWithGST-gst-costWithoutGST) as "GROSS@dividefactor",
    0 as "MARGIN@decimal"
from DailySalesSummaryByCategory t 
group by salesType, strftime('%Y-%m-%d', date(t.date/1000,'unixepoch', 'localtime'))
order by 1, 2;

@clear
@footer(|*|sum|sum|sum|sum|sum|c[6]/c[3]*100)
@row-function(|||||||c[6]/c[3]*100)
select 
    salesType as "TYPE",
    category as 'CATEGORY', 
	sum(gst) as "GST@dividefactor", 
    sum(valueWithGST-gst) as "VALUE@dividefactor", 
    sum(valueWithGST) as "COLLECTION@dividefactor", 
	sum(costWithoutGST) as "COST@dividefactor", 
	sum(valueWithGST-gst-costWithoutGST) as "GROSS@dividefactor",
	0 as "MARGIN@decimal"
from DailySalesSummaryByCategory
group by salesType, category, id    
order by salesType, id, category;