-- dependency on temp table DailySalesSummaryByCategory(id, date, salesType, category, valueWithGST, costWithoutGST, gst)
-- generated by command-before='generatedailysalessummarybycategory' in the ServerSideMenu.xml for the definition of the job 
-- using filter userParam="salesType in (select value from ul_keys where key='CashSalesType')"

@ifPDF
	@column-sizes(3|3|2|2|2|2|2|2)
	@row-function(|||||||c[6]/c[3]*100)
	@footer(|*|sum|sum|sum|sum|sum|c[6]/c[3]*100)
@end

select 
	'DAILY SALES' as 'REPORT',
	salesType as 'TYPE', 
	sum(effectiveGST) as "GST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST) as "VALUE@dividefactor@sum=sum", 
	sum(effectiveAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(costWithoutGST) as "COST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST-costWithoutGST) as "GROSS@dividefactor@sum=sum",
@ifExcel
	0 as "MARGIN@decimal@formula=G@row/D@row*100" 
@ifPDF
	0 as "MARGIN@decimal" 
@end
from DailySalesSummaryByCategory
group by salesType
order by 1;


@ifPDF
	@column-sizes(3|3|2|2|2|2|2|2)
	@row-function(|||||||c[6]/c[3]*100)
	@footer(|*|sum|sum|sum|sum|sum|c[6]/c[3]*100)
@end

select 
	type as "TYPE", 
	day as "DAY", 
	sum(effectiveGST) as "GST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST) as "VALUE@dividefactor@sum=sum", 
	sum(effectiveAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(costWithoutGST) as "COST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST-costWithoutGST) as "GROSS@dividefactor@sum=sum",
@ifExcel
	0 as "MARGIN@decimal@formula=G@row/D@row*100" 
@ifPDF
	0 as "MARGIN@decimal" 
@end
from (
    select  
       salesType as type,
       strftime('%Y-%m-%d', date(t.date/1000,'unixepoch', 'localtime')) ||' '|| getdayname(strftime('%w', date(t.date/1000,'unixepoch', 'localtime'))) as day, 
       sum(effectiveAmount) as effectiveAmount,
       sum(costWithoutGST) as costWithoutGST,
       sum(effectiveGST) as effectiveGST 
    from DailySalesSummaryByCategory t 
    group by salesType, strftime('%Y-%m-%d', date(t.date/1000,'unixepoch', 'localtime'))
) t 
group by type, day
order by 1, 2 desc;


@ifPDF
	@column-sizes(3|5|2|2|2|2|2|2)
	@row-function(|||||||c[6]/c[3]*100)
	@footer(|*|sum|sum|sum|sum|sum|c[6]/c[3]*100)
@end


select 
    salesType as "TYPE",
    category as 'CATEGORY', 
	sum(effectiveGST) as "GST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST) as "VALUE@dividefactor@sum=sum", 
	sum(effectiveAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(costWithoutGST) as "COST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST-costWithoutGST) as "GROSS@dividefactor@sum=sum",
@ifExcel
	0 as "MARGIN@decimal@formula=G@row/D@row*100" 
@ifPDF
	0 as "MARGIN@decimal" 
@end
from DailySalesSummaryByCategory
group by salesType, category
order by salesType, category;