
@ifPDF
	@column-sizes(8|8|8|2|15|2|3|4|8)
	@footer(||||*||sum|||)
@end

select  
   sh.transactionDate as "Transaction Date@datetime",
   sh.dateCreated as "System Date@datetime",
   (select dateDeleted from deletedsales where salesid = sh.id) as "Deleted On@datetime",
   getseqsales(sh.transactionDate, sh.id, sh.salestype) as "Rcpt@integer",
   (select gettoken(content,1) from entityFTS where rowid=e.docID)  as "Item Sold",
   sd.quantity||pt.code as "Q@integer",
   amount as "Amount@dividefactor@sum=sum",
   us.name as "Who Delete",
   (select reason from deletedsales where salesid=sh.id) as "Reason"
from salesheader sh
inner join salesdetail sd on sd.salesid=sh.id
inner join stock st on st.entityid=sd.stockid
inner join stockpackmaster sp on sp.stockID=sd.stockID and sp.packTypeID=sd.packTypeID
inner join types pt on pt.id=sd.packtypeID
inner join entity e on e.id=sd.stockid
inner join ul_sessions sdel on sh.sessionid=sdel.id
inner join ul_users us on us.id=sdel.userid
where sh.transactionDate between @fromdate and @todate and (sh.isdeleted = 1 or sh.id in (select salesid from deletedsales))
order by sh.transactionDate desc