
@ifPDF
	@column-sizes(1|1|1|1|1)
	@footer(||*|sum|)
@end

select  
   sh.dateCreated as "System Date@datetime",
   sh.transactionDate as "Transaction Date@date",
   sh.id as "SeqNo@integer",
   getseqsales(sh.transactionDate, sh.id, sh.salestype) as "ReceiptNo@integer",
   totalAmount as "Amount@dividefactor@sum=sum",
   us.name as "Who"
from salesheader sh
inner join ul_sessions sdel on sh.sessionid=sdel.id
inner join ul_users us on us.id=sdel.userid
where sh.dateCreated between @fromdate and @todate and
date(sh.transactionDate/1000,'unixepoch','localtime') != date(sh.dateCreated/1000,'unixepoch','localtime')
=@salestype
order by sh.dateCreated desc