select 
	'GST' as 'Report', 
	gstcode as 'GST Code', 
	sum(taxAmount) as "GST@dividefactor@sum=sum", 
	sum(value) as "VALUE@dividefactor@sum=sum", 
    sum(value+taxAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(cost) as "COST@dividefactor@sum=sum", 
	sum(value-cost) as "GROSS@dividefactor@sum=sum",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@decimal" 
from (
select  
   ifnull(gstcode, 'EXEMPTED') as gstcode, 
   sum(quantity*ifnull(packsize,1)) as qty, 
   sum(quantity*price) as value,
   sum(quantity*round(costprice,2)*sp.packsize) as cost, 
   sum(case when gstcode=(select value from ul_keys where key='GSTMarker') then ifnull(taxAmount,0) else 0 end) as taxAmount
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
where sd.IsDeleted is NULL and sh.isDeleted is NULL and transactionDate between @fromdate and @todate
and sh.salestype = (select value from ul_keys where key= 'CashSalesTypeID')
group by gstcode
) t 
group by gstcode
order by 1;

select 
	gstcode as 'GST Code', 
	cat as 'CATEGORY', 
	sum(taxAmount) as "GST@dividefactor@sum=sum", 
	sum(value) as "VALUE@dividefactor@sum=sum", 
  sum(value+taxAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(cost) as "COST@dividefactor@sum=sum", 
	sum(value-cost) as "GROSS@dividefactor@sum=sum",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@decimal" 
from (
select  
   ifnull(gstcode, 'EXEMPTED') as gstcode,
   t2.name as cat, 
   sum(quantity*ifnull(packsize,1)) as qty, 
   sum(quantity*price) as value,
   sum(quantity*round(costprice,2)*sp.packsize) as cost,
   sum(case when gstcode=(select value from ul_keys where key='GSTMarker') then ifnull(taxAmount,0) else 0 end) as taxAmount
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join types t2 on t2.id=s.typeID
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
where sd.IsDeleted is NULL and sh.isDeleted is NULL and transactionDate between @fromdate and @todate
and sh.salestype = (select value from ul_keys where key= 'CashSalesTypeID')
group by gstcode, t2.name
) t 
group by gstcode, cat
order by gstcode, cat;


select 
	gstcode as "GST", 
	day as "DAY", 
	sum(taxAmount) as "GST@dividefactor@sum=sum", 
	sum(value) as "VALUE@dividefactor@sum=sum", 
  sum(value+taxAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(cost) as "COST@dividefactor@sum=sum", 
	sum(value-cost) as "GROSS@dividefactor@sum=sum",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@decimal" 
from (
select  
   ifnull(gstcode, "EXEMPTED") as gstcode,
   strftime('%Y-%m-%d', date(transactionDate/1000,'unixepoch', 'localtime')) ||' '|| getdayname(strftime('%w', date(transactionDate/1000,'unixepoch', 'localtime'))) as day, 
   sum(quantity*ifnull(packsize,1)) as qty, 
   sum(quantity*price) as value,
   sum(quantity*round(costprice,2)*sp.packsize) as cost,
   sum(case when gstcode=(select value from ul_keys where key='GSTMarker') then ifnull(taxAmount,0) else 0 end) as taxAmount 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
inner join types t on t.id=sh.salestype
where sd.IsDeleted is NULL and sh.isDeleted is NULL and transactionDate between @fromdate and @todate
and sh.salestype = (select value from ul_keys where key= 'CashSalesTypeID')
group by gstcode, strftime('%Y-%m-%d', date(transactionDate/1000,'unixepoch', 'localtime'))
) t 
group by gstcode, day
order by gstcode, day desc;
