@ifPDF
	@column-sizes(1|1|3|5|1|1|1|1)
	@footer(|||*|sum||sum|sum)
@end

select 
  rh.id as "RECV-ID@number",
  rh.transactionDate as "INV-DATE@datetime",
  (select gettoken(content,1) from entityFTS where rowid=es.docID) as SUPPLIER,
	(select gettoken(content,1) from entityFTS where rowid=e.docID) as PRODUCT,
	rd.quantity*rd.price as "COST@dividefactor@sum=sum",
  rd.quantity * ifnull(sp.packsize,1) + ifnull(rd.bonusQty,0)*ifnull(spb.packsize, 1) as "QTY@number",
	rd.taxAmount as "GST@dividefactor@sum=sum",
	rd.amount as "AMOUNT@dividefactor@sum=sum"
from receiveheader rh
inner join receivedetail rd on rd.receiveid=rh.id
inner join stock s on rd.stockID = s.entityID
inner join entity e on e.id=rd.stockID
inner join entity es on es.id=rh.supplierID
inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid
inner join stockpackmaster spb on spb.stockid=rd.stockid and spb.packtypeid=rd.bonuspacktypeid
where rh.IsDeleted is NULL and rd.isDeleted is NULL and s.IsDeleted is NULL and rh.transactionDate between @fromdate and @todate
order by rh.id;
