-- DailySalesSummaryByCashier(id, cashier, gstcode, date, dateOnly, salesType, item, valueWithGST, costWithoutGST, gst, discount, discountAtTotal, rounding, terminal)
@ifPDF
	@column-sizes(3|3|4|4|7|2|2|2|2|2|2|2|2|2)
	@footer(||||*|sum|sum|sum|sum|sum|sum|(c[4]-c[6])/c[4]*100|(c[6]-c[9])/c[9]*100|sum)
@end
select 
	dateOnly as "Date@date",
	date as "Time@time",
	cashier as Cashier, 
    (select gettoken(content, 1) from entityFTS where rowid=e.docID)  as Customer,
	item as Item,
	valueB4disc as "RETAIL@dividefactor@sum=sum",
	valueWithGST-gst as "SOLD AMT@dividefactor@sum=sum",
	effectiveAmount-effectiveGST as "ACTUAL@dividefactor@sum=sum", 
	valueB4disc - (effectiveAmount-effectiveGST) as "DISC@dividefactor@sum=sum", 
	effectiveGST as "GST@dividefactor", 	
	costWithoutGST as "COST@dividefactor", 	
	((valueB4disc - (effectiveAmount-effectiveGST))/valueB4disc*100.0) as "%DISC@decimal",
	margin as "MARGIN%@decimal",
	effectiveAmount as "COLLECTION@dividefactor@sum=sum"
from DailySalesSummaryByCashier s 
left join entity e on e.id=s.customerID
where marginAboveCost =@margin
order by date;

-- TODO: Show payment made
-- select 
--		sh.id, 
--		t.name, 
--		totalAmount, 
--		py.paidAmount, 
--		(select gettoken(content,1) from entityfts ef inner join entity e on e.docid=ef.rowid where e.id=py.entityid) as [Credit To] 
-- from salesheader sh
-- inner join paymentreceived py on py.salesid=sh.id
-- inner join types t on t.id=py.paidby
-- order by sh.id
