@group(2,,,sum,sum,sum,sum,sum,)

select 
	cat as CATEGORY,
	spaces(code, name) as NAME, 
  gstcode as TAX,
	sum(qty) as "QTY@integer", 
	sum(valueWithGST-taxAmount) as "VALUE@dividefactor@sum=sum", 
	sum(taxAmount) as "GST@dividefactor@sum=sum", 
	sum(valueWithGST) as "TOTAL@dividefactor@sum=sum", 
	sum(cost) as "COST@dividefactor@sum=sum", 
	sum(valueWithGST-taxAmount-cost) as "GROSS@dividefactor@sum=sum",
	0 as "MARGIN@decimal@formula=(I@row)/E@row*100" 
from (
select  
   cat.name as cat,
   s.gstcode as gstcode,
   (select gettoken(content,0) from entityFTS where rowid=e.docID) as code,
   (select gettoken(content,1) from entityFTS where rowid=e.docID) as name, 
   quantity*ifnull(packsize,1) as qty, 
   amount as valueWithGST,
   quantity*round(costprice,2)*sp.packsize as cost,
   taxAmount as taxAmount
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join types cat on cat.id=s.typeid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
where sd.IsDeleted is NULL and sh.IsDeleted is NULL and transactionDate between @fromdate and @todate and sd.stockID=@stockid
) t 
group by cat, code, name, gstcode
order by cat, code, gstcode;


