@ifPDF
	@column-sizes(7|2|2|2|2|2|2|2)
	@footer(*||sum|sum|sum|sum|sum|c[7]/c[3]*100)
@end


select 
	item as NAME, 
    date as "Transaction Date@date",
	sum(quantity) as "QTY@integer", 
	sum(effectiveAmount-effectiveGST) as "VALUE@dividefactor@sum=sum", 
	sum(effectiveGST) as "GST@dividefactor@sum=sum", 
	sum(effectiveAmount) as "TOTAL@dividefactor@sum=sum", 
	sum(costWithoutGST) as "COST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST-costWithoutGST) as "GROSS@dividefactor@sum=sum",
	sum(effectiveAmount-effectiveGST-costWithoutGST) / sum(effectiveAmount-effectiveGST)*100.0 as "MARGIN@decimal" 
from DailySalesSummaryByCategory dssc
inner join PaymentReceived pr on (pr.salesID=dssc.id)
inner join types t on t.id=pr.paidby
where t.id = @paymenttype
group by item, date
order by item, date;