@column-sizes(4|2|2|2|1|1|1)

select 
	(select gettoken(content,1) from entityfts where rowid=ec.docid) as Name,
	(select gettoken(content,2) from entityfts where rowid=ec.docid) as IC,
	(select gettoken(content,4) from entityfts where rowid=ec.docid) as Tel,
  sh.transactionDate as 'Date@date',
	sd.quantity as 'Qty@integer',
  sd.price as "Price@dividefactor", 
  sd.amount as "Amount@dividefactor" 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join entity ec on ec.id=sh.customerID
inner join entity es on es.id=sd.stockID
where sh.customerID is not null 
and sd.stockID = @stockid and sh.transactionDate between @fromdate and @todate
and ec.isDeleted is NULL and es.isDeleted is NULL and sd.isDeleted is NULL and sh.isDeleted is NULL
and sd.quantity > 0
order by 1, sh.transactionDate desc;
