@break-page(0)
@column-sizes(5|1|2|6|1|1|1)
@key-columns(1,2,3,4)

select 
	(select spaces(gettoken(content,2), gettoken(content,1)) from entityFTS where rowid=e.docID) as DRUG, 
	tdate as "Date@date", 
	(select multilines(
		(select gettoken(content,2) from entityFTS where rowid=ec.docID),
		(case when p.type = 'P' then (select refNo from receiveheader where id = p.sales_id) else '' end)
	)) as "IC/Reg/Invoice", 
	(select multilines(gettoken(content,1),gettoken(content,7)) from entityFTS where rowid=ec.docID) as "NAME", 
	p.quantity as "QTY@number",
	(select packdescription from stockpackmaster where stockid=p.stockid order by packsize limit 1) as "PACK",
	formatqoh(p.stockid, p.qoh) as "STOCK"
from poisonusage p
inner join entity e on e.id=p.stockID
inner join entity ec on ec.id=p.consumedByID
inner join entityattributes ea on ea.entityid = e.id
inner join types cat on (cat.id = ea.typeid and cat.parentid=(select value from ul_keys where key='ScheduleTypeGroupID'))
order by p.stockid, tdate, p.qoh desc;
